close all
clear all
global u_t u_t1 jft
warning off
clc

addpath('C:\Dropbox\bpea\forecasts');


% Import forecasts
% T0=1; % start in 1969
T0=75; % start in 1976
%actual ur:
ur=csvread('v1ur.csv',T0,1);
ur0=ur;
uf_ARIMA=csvread('ur_arima.csv',T0,1);
uf_Ubar=csvread('ur_ustar.csv',T0,1);
uf_SSUR2_s=csvread('ur_ssur_s.csv',T0,1);
uf_SSUR2_f=csvread('ur_ssur_f.csv',T0,1);
uf_GB=csvread('ur_gb.csv',T0,1);
uf_SPF=csvread('ur_spf.csv',T0,1);
%NOTE: this is SSUR2 in real time
uf_SSUR2=csvread('ur_ssur2.csv',T0,1);
uf_VAR=csvread('ur_var.csv',T0,1);

eSSUR2=uf_SSUR2-ur;
uf_Staff=[uf_ARIMA uf_Ubar uf_VAR uf_SSUR2_s uf_SSUR2_f];

name=['eARI'; 'eUba'; 'eVAR'; 'eSSs'; 'eSSf'];


for j=1:round(size(uf_Staff,2)/4)-1
    
    uStaff=uf_Staff(:,1+(j-1)*5:(j)*5);
    eSS=eSSUR2;ur=ur0;
    
    % % Uncomment to get the GW test for SPF and GB
    %     %I get rid of the rows with zeros (ie no forecasts)
    %     [rows,cols,vals] = find(uStaff(:,1)==0);
    %     uStaff(rows,:)=[];
    %     ur(rows,:)=[];
    %     eSS(rows,:)=[];
    
    
    eStaff=uStaff-ur;
    Tr=18; eSS=eSS(1:end-Tr,:); eStaff=eStaff(1:end-Tr,:);
    
    disp('**********')
    
    disp(horzcat('RMSEs Staff forecast:' ));
    disp(horzcat('Model_' ,num2str(name(j,:)) ));
    disp(num2str((sum((100*eStaff).^2,1)./length(eStaff)).^.5))
    
    disp(' ')
    disp(horzcat('Relative MSE ofSSUR forecast:' ));
    disp(horzcat('Var_' ,num2str(name(j,:)), 'model / Var SS model:' ));
    disp(num2str(sum(eStaff.^2,1)./sum(eSS.^2,1)))
        
    dssr=eStaff.^2-eSS.^2;
    disp(horzcat([' ']));
    Pval=[];
    for i=1:size(eSS,2)
        [teststat,critval,pval]=CPAtest(dssr(:,i),ones(length(dssr),1),i);
        Pval=[Pval pval];
    end
    disp(horzcat('Giacomini-White test at forecast horizon, p-values' ));
    disp(num2str(Pval))
 end

